/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Nokia Corporation and its Subsidiary(-ies) nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QtGui>

#include "wetrixboard.h"
#include "wetrixwindow.h"


wetrixWindow::wetrixWindow()
{
    board = new wetrixBoard;
    nextPieceLabel = new QLabel;
    nextPieceLabel->setFrameStyle(QFrame::Box | QFrame::Raised);
    nextPieceLabel->setAlignment(Qt::AlignCenter);
    board->setNextPieceLabel(nextPieceLabel);

    scoreLcd = new QLCDNumber(5);
    scoreLcd->setSegmentStyle(QLCDNumber::Filled);

    levelLcd = new QLCDNumber(2);
    levelLcd->setSegmentStyle(QLCDNumber::Filled);
    linesLcd = new QLCDNumber(5);
    linesLcd->setSegmentStyle(QLCDNumber::Filled);


    startButton = new QPushButton(tr("\n&Start\n"));
    startButton->setFocusPolicy(Qt::NoFocus);
    quitButton = new QPushButton(tr("\n&Quit\n"));
    quitButton->setFocusPolicy(Qt::NoFocus);
    pauseButton = new QPushButton(tr("\n&Pause\n"));

    pauseButton->setFocusPolicy(Qt::NoFocus);


    // die speziellen Buttons
    leftButton = new QPushButton(tr("\nLinks\n"));
    leftButton->setFocusPolicy(Qt::NoFocus);
    connect(leftButton, SIGNAL(clicked()), board, SLOT(leftpressed()));


    leftturnButton = new QPushButton(tr("\n< Display turn\n"));
    leftturnButton->setFocusPolicy(Qt::NoFocus);
    connect(leftturnButton, SIGNAL(clicked()), board, SLOT(leftturnpressed()));


    rightButton = new QPushButton(tr("\nRechts\n"));
    rightButton->setFocusPolicy(Qt::NoFocus);
    connect(rightButton, SIGNAL(clicked()), board, SLOT(rightpressed()));

    rightturnButton = new QPushButton(tr("\nDisplay turn>\n"));
    rightturnButton->setFocusPolicy(Qt::NoFocus);
    connect(rightturnButton, SIGNAL(clicked()), board, SLOT(rightturnpressed()));

    upButton = new QPushButton(tr("\nLinksdreh\n"));
    upButton->setFocusPolicy(Qt::NoFocus);
    connect(upButton, SIGNAL(clicked()), board, SLOT(uppressed()));

    downButton = new QPushButton(tr("\nRechtsdreh\n"));
    downButton->setFocusPolicy(Qt::NoFocus);
    connect(downButton, SIGNAL(clicked()), board, SLOT(downpressed()));

    spaceButton = new QPushButton(tr("\nDrop\n"));
    spaceButton->setFocusPolicy(Qt::NoFocus);
    connect(spaceButton, SIGNAL(clicked()), board, SLOT(blankpressed()));
    spaceButton2 = new QPushButton(tr("\nDrop\n"));
    spaceButton2->setFocusPolicy(Qt::NoFocus);
    connect(spaceButton2, SIGNAL(clicked()), board, SLOT(blankpressed()));


    connect(startButton, SIGNAL(clicked()), board, SLOT(start()));

    connect(quitButton , SIGNAL(clicked()), qApp, SLOT(quit()));
    connect(pauseButton, SIGNAL(clicked()), board, SLOT(pause()));
    connect(board, SIGNAL(scoreChanged(int)), scoreLcd, SLOT(display(int)));
    connect(board, SIGNAL(levelChanged(int)), levelLcd, SLOT(display(int)));
    connect(board, SIGNAL(linesRemovedChanged(int)),linesLcd, SLOT(display(int)));


    QGridLayout *layout = new QGridLayout;


    //leftturn
    layout->addWidget(leftturnButton, 0, 0);
    layout->addWidget(createLabel(tr("NEXT")), 1, 0);
    layout->addWidget(nextPieceLabel, 2, 0);
    layout->addWidget(createLabel(tr("LEVEL")), 3, 0);
    layout->addWidget(levelLcd, 4, 0);
    layout->addWidget(startButton, 5, 0);

    //spacebutton
    layout->addWidget(spaceButton, 8, 0);

    //upbutton
    layout->addWidget(upButton, 9, 0);
    //leftbutton
    layout->addWidget(leftButton, 10, 0);


    layout->addWidget(board, 0, 1, 11, 1);




    //rightturn
    layout->addWidget(rightturnButton, 0, 2);
    layout->addWidget(createLabel(tr("SCORE")), 1, 2);
    layout->addWidget(scoreLcd, 2, 2);
    layout->addWidget(createLabel(tr("LINES REMOVED")), 3, 2);
    layout->addWidget(linesLcd, 4, 2);
    layout->addWidget(quitButton, 5, 2);
    layout->addWidget(pauseButton, 6, 2);
    //spacebutton
    layout->addWidget(spaceButton2, 8, 2);
    //downbutton
    layout->addWidget(downButton, 9, 2);
    //rightbutton
    layout->addWidget(rightButton, 10, 2);



    setLayout(layout);

    setWindowTitle(tr("wetrix"));
    resize(550, 370);
}
QLabel *wetrixWindow::createLabel(const QString &text)
{
    QLabel *lbl = new QLabel(text);
    lbl->setAlignment(Qt::AlignHCenter | Qt::AlignBottom);
    return lbl;
}
